package com.tomas.ht_ydt.Adapter;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.ht_ydt.InboundDetail_Activity;
import com.tomas.ht_ydt.InboundScheduleDetail_Activity;
import com.tomas.ht_ydt.ListData.Schedule_Item;
import com.tomas.ht_ydt.OutboundCrusher_Activity;
import com.tomas.ht_ydt.OutboundDetail_Activity;
import com.tomas.ht_ydt.OutboundInjection_Activity;
import com.tomas.ht_ydt.R;
import com.tomas.ht_ydt.lib.ActionType;
import com.tomas.ht_ydt.lib.Settings;

import java.text.DecimalFormat;
import java.util.List;

public class ScheduleItem_Adapter extends RecyclerView.Adapter<ScheduleItem_Adapter.ViewHolder> {
    List<Schedule_Item> data;
    Context context;
    String Action_type;
    DecimalFormat decimalFormat;

    public ScheduleItem_Adapter(List<Schedule_Item> dataset, Context context, String Action_type ) {
        data = dataset;
        this.context = context;
        this.Action_type = Action_type;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{

        ConstraintLayout layout;
        LinearLayout layout_supplier, layout_lot_no;
        TextView txt_order_no, txt_supplier, txt_part_no, txt_part_name, txt_location, txt_qty, txt_lot_no;
        public ViewHolder(View itemview){
            super(itemview);
            layout = (ConstraintLayout) itemview.findViewById(R.id.item_row);
            layout_supplier = (LinearLayout)itemview.findViewById(R.id.layout_supplier);
            layout_lot_no = (LinearLayout)itemview.findViewById(R.id.layout_lot_no);
            txt_order_no = (TextView)itemView.findViewById(R.id.txt_order_no);
            txt_supplier = (TextView)itemView.findViewById(R.id.txt_supplier);
            txt_part_no = (TextView)itemView.findViewById(R.id.txt_part_no);
            txt_part_name = (TextView)itemView.findViewById(R.id.txt_part_name);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_location = (TextView)itemView.findViewById(R.id.txt_location);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);

        }
    }


    @NonNull
    @Override
    public ScheduleItem_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_schedule,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ScheduleItem_Adapter.ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,##0.00");
        final Schedule_Item item = data.get(position);
        holder.txt_order_no.setText(item.getOrder_no());
        holder.txt_supplier.setText(item.getSupplier());
        holder.txt_part_no.setText(item.getPart_no());
        holder.txt_part_name.setText(item.getPart_name());
//        holder.txt_qty.setText(decimalFormat.format(Float.parseFloat(item.getAct_qty()))+"/"+decimalFormat.format(Float.parseFloat(item.getQty()))+" "+item.getControl_unit());
        holder.txt_qty.setText(decimalFormat.format(Float.parseFloat(item.getAct_qty()))+"/"+decimalFormat.format(Float.parseFloat(item.getQty()))+" "+item.getUnit_qty());

        if (Action_type.trim().equals(ActionType.Action_Type.OUTBOUND.toString())){
            holder.layout_supplier.setVisibility(View.GONE);
            holder.layout_lot_no.setVisibility(View.VISIBLE);
            holder.txt_lot_no.setText(item.getFifo_lot_no());
            holder.txt_location.setText(item.getFifo_location());

        }else {
            holder.layout_supplier.setVisibility(View.VISIBLE);
            holder.layout_lot_no.setVisibility(View.GONE);
            holder.txt_location.setText(item.getDest_location_id());
        }

        String status = item.getStatus();
        if (status.toString().trim().equals("COMPLETED")){
            holder.layout.setBackgroundResource(R.color.status_completed);
        }else if (status.toString().trim().equals("WORKING")){
            holder.layout.setBackgroundResource(R.color.status_working);
        }else{//IMPORTED
            if (Action_type.trim().equals(ActionType.Action_Type.OUTBOUND.toString())
            && item.getFifo_location().trim().equals("")){
                holder.layout.setBackgroundResource(R.color.color_orange2);
            }else {
                holder.layout.setBackgroundResource(R.color.status_imported);
            }
        }

            holder.layout.setOnClickListener(new View.OnClickListener() {
                Intent i;
                @Override
                public void onClick(View v) {
                    Log.d("A", "id: " + item.getId());
                    Log.d("A", "Click: " + item.getSrc_dept_id()+"/"+item.getDest_dept_id());


                    if (!status.trim().equals("COMPLETED")) {
                        if (Action_type.trim().equals(ActionType.Action_Type.OUTBOUND.toString())) {
                            if (item.getAction_det().trim().equals("Outbound Material Crusher")) {//inchart = 20 can see only
                                i = new Intent(context.getApplicationContext(), OutboundCrusher_Activity.class);

                            } else {
                                i = new Intent(context.getApplicationContext(), OutboundDetail_Activity.class);//Outbound Material Press,Outbound Material Assy, Outbound Delivery
                            }
                        } else {
                            i = new Intent(context.getApplicationContext(), InboundScheduleDetail_Activity.class);
                        }
                    }else if (Action_type.trim().equals(ActionType.Action_Type.OUTBOUND.toString())
                        && item.getAction_det().trim().equals("Outbound Material Crusher")) {
                            i = new Intent(context.getApplicationContext(), OutboundCrusher_Activity.class);
                    }else {
                        return;
                    }
                    i.putExtra("schedule_id", item.getId());
                    i.putExtra("ref_id", item.getRef_id());
                    i.putExtra("order_no", item.getOrder_no());
                    i.putExtra("part_no", item.getPart_no());
                    i.putExtra("part_name", item.getPart_name());
                    i.putExtra("dest_location_id", item.getDest_location_id());
                    i.putExtra("plan_qty", item.getQty());
                    i.putExtra("act_qty", item.getAct_qty());
                    i.putExtra("supplier", item.getSupplier());
                    i.putExtra("control_unit", item.getControl_unit());
                    i.putExtra("product_no", item.getProduct_no());
                    i.putExtra("action_det", item.getAction_det());
                    i.putExtra("crusher_ratio", item.getCrusher_ratio());
                    i.putExtra("virgin_qty", item.getVirgin_qty());
                    i.putExtra("crusher_qty", item.getCrusher_qty());
                    i.putExtra("status", item.getStatus());
                    i.putExtra("unit_qty", item.getUnit_qty());
                    i.putExtra("ref_parts_no", item.getRef_parts_no());
                    context.startActivity(i);
                }
            });
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
